<?php
/*--------------------------------------------------------------
   Text.php 2021-08-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Number\Value;

class Number implements Data
{
    /**
     * @var Value
     */
    private $number;
    
    /**
     * @var string
     */
    private $type;
    
    
    /**
     * Constructor.
     */
    private function __construct(Value $number)
    {
        $this->number = $number;
        $this->type   = 'number';
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Value $number): self
    {
        return new self($number);
    }
    
    
    /**
     * Return number.
     */
    public function number(): Value
    {
        return $this->number;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->type;
    }
}